using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using Elasticsearch.Net;
using Elasticsearch.Net.Aws;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.DurableTask;
using Microsoft.Azure.WebJobs.Extensions.Http;
using Microsoft.Azure.WebJobs.Host;
using Microsoft.Data.SqlClient;
using Microsoft.Extensions.Logging;
using Nest;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using RestSharp;
//curl -X POST http://localhost:7071/api/GetEsearchData_HttpStart -H 'Content-Type: application/json' -d "{\"ADFsettings\": [{\"SettingName\":\"instanceURL\",\"SettingVal\":\"https://search-blahxxxxxxx.region.es.amazonaws.com/\"},{\"SettingName\": \"StartDateADF\",\"SettingVal\":\"2021-01-01T00:00:00\"},{\"SettingName\": \"EndDateADF\",\"SettingVal\":\"2022-12-01T00:00:00\"},{\"SettingName\": \"QID\",\"SettingVal\":\"12\"},{\"SettingName\": \"filterby\",\"SettingVal\":\"ALL\"}]}"

namespace AWSFunctions
{
    public static class GetEsearchData
    {
        private static string apiresponse;
        private static string errmsg;
        private static int errflag;
        private static string sqlServer = Environment.GetEnvironmentVariable("sqlServer");
        private static string sqlInitialCatalog = Environment.GetEnvironmentVariable("sqlCatalog");
        private static string sqlUserID = Environment.GetEnvironmentVariable("sqlUserID");
        public static string sqlPassword;
        public static int rcInsert;
        static TimeZoneInfo easternZone = TimeZoneInfo.FindSystemTimeZoneById("Eastern Standard Time");
        public static string loaddate;

        public static string sauth; //apikey parameter 
        public static string instanceURL;
        public static string page;
        public static string ESquery;
        public static string adfQID;
        public static string adfSearchparam;


        [FunctionName("GetEsearchData")]
        public static async Task<List<string>> RunOrchestrator(
            [OrchestrationTrigger] IDurableOrchestrationContext context)
        {
            var outputs = new List<string>();
            ADFRequest data = context.GetInput<ADFRequest>();
            outputs.Add(await context.CallActivityAsync<string>("GetEsearchData_Process", data));
            return outputs;
        }

        // Security getkey 
        private static byte[] GetKey(string password)
        {
            string pwd = null;

            if (Encoding.UTF8.GetByteCount(password) < 24)
            {
                pwd = password.PadRight(24, ' ');
            }
            else
            {
                pwd = password.Substring(0, 24);
            }
            return Encoding.UTF8.GetBytes(pwd);
        }

        /// <summary>
        /// Decrypt using 3DES (192 bits)
        /// </summary>
        private static string Decrypt(string data)
        {
            TripleDESCryptoServiceProvider DES = new TripleDESCryptoServiceProvider();
            DES.Mode = CipherMode.ECB;
            DES.Key = GetKey("qqqqqqqqqqaaaaaaaaaaa");
            DES.Padding = PaddingMode.PKCS7;
            ICryptoTransform DESEncrypt = DES.CreateDecryptor();
            Byte[] Buffer = Convert.FromBase64String(data.Replace(" ", "+"));
            return Encoding.UTF8.GetString(DESEncrypt.TransformFinalBlock(Buffer, 0, Buffer.Length));
        }

        [FunctionName("GetEsearchData_Process")]
        public static string GetEsearchData_Process([ActivityTrigger] ADFRequest ADFReq, ILogger log)
        {
            log.LogInformation($"Begin process: {DateTime.Now}");
            sqlPassword = Decrypt("ujvt555555555555555555555");
            sqlPassword.ToString();
            string StartDateADF = "";
            string EndDateADF = "";

            foreach (var adfset in ADFReq.ADFsettings) //reads params passed in the ADFsettings argument
            {
                log.LogInformation("ActivityFunction reading:" + adfset.SettingName+ " = " + adfset.SettingVal);
                if (adfset.SettingName == "instanceURL")
                {
                    instanceURL = adfset.SettingVal.Trim();
                }
                if (adfset.SettingName == "StartDateADF")
                {
                    StartDateADF = adfset.SettingVal.Trim();
                }
                if (adfset.SettingName == "EndDateADF")
                {
                    EndDateADF = adfset.SettingVal.Trim();
                }
                if (adfset.SettingName == "QID")
                {
                    adfQID = adfset.SettingVal.Trim();
                }
                if (adfset.SettingName == "Searchparam")
                {
                    adfSearchparam = adfset.SettingVal.Trim();
                }
            }
            if (string.IsNullOrEmpty(page))
            {
                page = "0";
            }
            log.LogInformation($"Settings obtained: {DateTime.Now}" + "-->" + sauth);
            ReadElasticData(adfSearchparam, Convert.ToInt32(adfQID), new string[] { StartDateADF, EndDateADF }); 
            log.LogInformation("End function:" + string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", DateTime.Now));
            return "Process OK";
        }

        static public int ReadElasticData(string sSearchparam,int Queryid,string[] StartEndDates=null)
        {
            string StartDate="";
            string EndDate = "";
            if (StartEndDates != null)
            {
               StartDate=  StartEndDates[0];
               EndDate = StartEndDates[1];
            }

            SQLGetQuery(Queryid);
            string SearchparamQry = "";
            ESquery = ESquery.Replace("#DateGTE#", StartDate);
            ESquery = ESquery.Replace("#DateLT#", EndDate);

            if (sSearchparam != "ALL")
            {
                SearchparamQry = " {\"match\": {\"mtg1Searchparam\": \"" + sSearchparam + "\"}},";
                ESquery = ESquery.Replace("#mtg1Searchparam#", sSearchparam); 
            }
            else
            {
                ESquery= ESquery.Replace("{\"match\": {\"mtg1Searchparam\": \"#mtg1Searchparam#\"}},", ""); 
            }

            // This constructor will look up AWS credentials in the
            // same way that the AWSSDK does automatically.
            var awscr = new Amazon.Runtime.BasicAWSCredentials("myaccesskey", "secret");
            var reg =  Amazon.RegionEndpoint.USWest2;
            var httpConnection = new AwsHttpConnection(awscr,reg);
            var pool = new SingleNodeConnectionPool(new Uri(instanceURL));
            var config = new ConnectionSettings(pool, httpConnection);
            //Set DisableDirectStreaming() on ConnectionSettings to force it to be set on the response.>
            config.DisableDirectStreaming();
           // var client = new ElasticClient(config);
            var clientlow = new ElasticLowLevelClient(config);
         
            var searchResponse = clientlow.Search<StringResponse>("your endpoint here", ESquery);
            var successful = searchResponse.Success;

             apiresponse = searchResponse.Body;
            string shardstotal = "1", shardssuccessful = "0";
            JObject jobj = JObject.Parse(apiresponse);
            shardstotal = jobj["_shards"]["total"].ToString();
            shardssuccessful = jobj["_shards"]["successful"].ToString();
           // shardstotal = "111";//test breaking
            if (shardstotal != shardssuccessful)
            {
                successful = false;
                throw new Exception("Error shards:successful<> total");
            }

            if (successful)
            {
                SQLParseInsert(apiresponse, false, "dbo.usp_LoadES",sSearchparam, Queryid); 
                return 0;
            }
            else
            {
                throw new Exception("Error response.");
                return 1;
            }
        } //end 

        static public int ReadPageESData(string esquery) // To scroll through many pages of results unaggregated query only
        {

             // This constructor will look up AWS credentials in the
            // same way that the AWSSDK does automatically.
            var awscr = new Amazon.Runtime.BasicAWSCredentials("x", "ycgI3cu+X4r");
            var reg = Amazon.RegionEndpoint.USWest2;
            var httpConnection = new AwsHttpConnection(awscr, reg);
            var pool = new SingleNodeConnectionPool(new Uri("https://search-url.ams-xxxxxxxxxx.us-west-2.es.amazonaws.com/"));
            var config = new ConnectionSettings(pool, httpConnection);
            //Set DisableDirectStreaming() on ConnectionSettings to force it to be set on the response.>
            config.DisableDirectStreaming();
            var client = new ElasticClient(config);
            var clientlow = new ElasticLowLevelClient(config);

            string Fromsize = "";
            Fromsize = "{\"size\": 5000,"; //set this as needed
            string qry;
   
            string aggqry = "   \"query\": {         \"bool\": { \"must_not\": [ " +
                "{\"match\": {\"mtg1Searchparam\": \"cars\"}}," +
                 "{\"match\": {\"Searchparam\": \"planes\"}}," +
                  "  {\"match\": {\"state\": \"FL\"}}, " +
                  "{\"range\": {\"datedDate\": {\"gte\": \"2020-01-01T00:00:00\"}}},                " +
                  " {\"range\": {\"datedDate\": {\"lt\": \"2020-07-01T00:00:00\"}}}    ]   }  } "    ;
            qry = Fromsize + aggqry + "}";


            SearchRequestParameters srch= new SearchRequestParameters();
            TimeSpan ts = new TimeSpan(0,0, 120);
            srch.Scroll=ts;

            var searchResponse = clientlow.Search<StringResponse>("yoururl-history", qry,srch);
            var successful = searchResponse.Success;

            apiresponse = searchResponse.Body;
            int loop = 0;
            //get scrollID
            string scrollID="";
            JObject jobj = JObject.Parse(apiresponse);
            scrollID = jobj["_scroll_id"].ToString();
                PostData scrbody = "";
            scrbody = "  {\"scroll\" : \"1m\", " +
                  " \"scroll_id\": \""+ scrollID+ "\"}       ";

            var scrollResponse = clientlow.Scroll<StringResponse>(scrbody);

            //    responseBytes = responseBytes.ToString();

            loop += 1;
            if (successful)
            {
                SQLParseInsert(apiresponse, true, "dbo.usp_LoadESAll", esquery,0); // parses json in SQL proc and is faster
                while (true)
                {
                    Console.WriteLine(scrollID);

                     scrbody = "  {\"scroll\" : \"1m\", " + " \"scroll_id\": \"" + scrollID + "\"} ";
                    var scrollResp = clientlow.Scroll<StringResponse>(scrbody);

                    SQLParseInsert(scrollResp.Body, false, "dbo.usp_LoadESAll", esquery,0);
                    //build next scroll
                    JObject jobjin = JObject.Parse(scrollResp.Body);
                    scrollID = jobjin["_scroll_id"].ToString();
                    if (scrollID.Length==0)
                    {
                        Console.WriteLine(scrollID);
                        Console.WriteLine("missing scrollID"+ DateTime.Now);
                        break;
                    }
                }

                return 0;
            }
            else
            {
                return 1;
            }
        } //end 

        static public string SQLParseInsert(string jsonIn, bool TruncateTable, string SProcname, string sSearchparam, int Queryid)
        {
            errmsg = "";
            try
            {
                SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();
                builder.DataSource = sqlServer;
                builder.UserID = sqlUserID;
                builder.Password = sqlPassword;
                builder.InitialCatalog = sqlInitialCatalog;

                using (SqlConnection connection = new SqlConnection(builder.ConnectionString))
                {
                    //    Console.WriteLine("Replace single quotes in json response");
                   // jsonIn = jsonIn.Replace("'", "");
                    //  string loaddate= DateTime.Now.ToString("yyyyMMddHHmmssfff");
                    loaddate = string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", TimeZoneInfo.ConvertTimeFromUtc(DateTime.UtcNow, easternZone));

                    String sql = "";
                    sql = SProcname;

                    using (SqlCommand command = new SqlCommand(sql, connection))
                    {
                        connection.Open();
                        command.CommandType = CommandType.StoredProcedure;
                        command.Parameters.Add(new SqlParameter("@TruncateTable", TruncateTable));
                        if (sSearchparam!="?")
                        {
                            command.Parameters.Add(new SqlParameter("@sSearchparam", sSearchparam));
                        }

                        command.Parameters.Add(new SqlParameter("@JsonResponse", jsonIn));
                        command.Parameters.Add(new SqlParameter("@LoadDate", loaddate));
                        command.Parameters.Add(new SqlParameter("@QID", Queryid));
                        command.CommandTimeout = 60;
                        rcInsert = command.ExecuteNonQuery();
                    }
                }
                return errmsg;
            }
            catch (SqlException e)
            {
                Console.WriteLine(e.ToString());
                //   il.LogInformation(jsonIn);
                errmsg = "Error:" + e.ToString();
               // return errmsg;
                throw new Exception("Error SQLParseInsert method:" + errmsg);
            }
            //    Console.WriteLine(response.Content);
        }

        static public string SQLGetQuery(int QueryID) //reads a query from a table 
        {
            errmsg = "";
            try
            {
                SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();
                builder.DataSource = sqlServer;
                builder.UserID = sqlUserID;
                builder.Password = sqlPassword;
                builder.InitialCatalog = sqlInitialCatalog;

                using (SqlConnection connection = new SqlConnection(builder.ConnectionString))
                {
                    Console.WriteLine("Get queryId:" + QueryID);
                    String sql = " ";
                    sql = "dbo.usp_GetElasticdbQuery";
                    using (SqlCommand command = new SqlCommand(sql, connection))
                    {
                        command.CommandType = CommandType.StoredProcedure;
                        command.Parameters.Add(new SqlParameter("@QueryID", QueryID));
                        connection.Open();
                        using (SqlDataReader reader = command.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                ESquery = reader.GetString(0); 
                            }
                        }
                    }
                }
                return ESquery;
            }
            catch (SqlException e)
            {
                Console.WriteLine(e.ToString());
                //   il.LogInformation(jsonIn);
                errmsg = "Error:" + e.ToString();
                return errmsg;
            }
        }

        [FunctionName("GetEsearchData_HttpStart")]
        public static async Task<HttpResponseMessage> HttpStart(
            [HttpTrigger(AuthorizationLevel.Anonymous, "post")] HttpRequestMessage req,
            [DurableClient] IDurableOrchestrationClient starter,
            ILogger log)
        {         
            log.LogInformation("http start:" + string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", DateTime.Now));
            req.Content.Headers.Remove("Content-Type");
            req.Content.Headers.Add("Content-Type", "application/json");

            var data = await req.Content.ReadAsAsync<ADFRequest>();
            // Function input comes from the request content.
            string instanceId = await starter.StartNewAsync("GetEsearchData", data);
            log.LogInformation($"Started orchestration with ID = '{instanceId}'.");

            return starter.CreateCheckStatusResponse(req, instanceId);
        }

        public class ADFSET
        {
            public string SettingName { get; set; }
            public string SettingVal { get; set; }
        }

        public class ADFRequest
        {
            public List<ADFSET> ADFsettings { get; set; }
        }

        class ADFparams
        {
            public List<string> ParamNames { get; set; }
        }

    }
}