using System;
using System.Collections.Generic;
using System.Data;
using System.Net.Http;
using System.Threading.Tasks;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.DurableTask;
using Microsoft.Azure.WebJobs.Extensions.Http;
using Microsoft.Azure.WebJobs.Host;
using Microsoft.Data.SqlClient;
using Microsoft.Extensions.Logging;
using RestSharp;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using System.Text;
using System.Security.Cryptography;
using Azure.Security.KeyVault.Secrets;
using Azure.Identity;
using Microsoft.IdentityModel;
using Microsoft.IdentityModel.Clients.ActiveDirectory;
using Microsoft.Rest;

//curl -X POST http://localhost:7071/api/GetADF_AdHoc_HttpStart -H 'Content-Type: application/json' -d "{\"ADFsettings\": [{\"SettingName\":\"PBIWSfilter\",\"SettingVal\":\"?$filter= not contains(name,'xBI') and not contains(name,'Testing')\"},{\"SettingName\": \"extraSetting\",\"SettingVal\":\"test\"}]}"
//https://docs.microsoft.com/en-us/rest/api/datafactory/trigger-runs/query-by-factory?tabs=HTTP

namespace AzADF
{
    public static class ADF_AdHoc
    {
        public static string sauth = "";
        private static string ADFResourceGroup = Environment.GetEnvironmentVariable("ADFresGroup");
        private static string ADFinstance = Environment.GetEnvironmentVariable("ADFinstance");
        public static Dictionary<string, string> dictTriggers = new Dictionary<string, string>();

        private static string ADFgatewayURL = String.Concat("https://management.azure.com/subscriptions/75c2135f-0d72-4e4e-8c53-2f4d308506e1/resourceGroups/",
          ADFResourceGroup, "/providers/Microsoft.DataFactory/factories/", ADFinstance);

        private static string PBIWSfilter; // workspace filter query from adfsettings json post body
        private static string errmsg;
        private static int errflag;
        private static string sqlServer = Environment.GetEnvironmentVariable("sqlServer");
        private static string sqlInitialCatalog = Environment.GetEnvironmentVariable("sqlCatalog");
        private static string sqlUserID = Environment.GetEnvironmentVariable("sqlUserID");
        public  static string sqlPassword; 
        public  static int rcInsert;
        static TimeZoneInfo easternZone = TimeZoneInfo.FindSystemTimeZoneById("Eastern Standard Time");       
        public static string loaddate;
        public static DateTime loaddateUTC; //for time filtering ADF by utc datetime
        public static string lastUpdatedAfter; //for time filtering ADF by utc datetime
        public static string lastUpdatedBefore; //for time filtering ADF by utc datetime

        public static int LastNhours=24; //get history for lastN hours eg.24

        public const string client_id = "x";
        private const string client_key = "x";
        private const string subscription_id = "x";
        private const string tenant_id = "x";
        public static string PagingToken;

        [FunctionName("GetADF_AdHoc")]
        public static async Task<List<string>> RunOrchestrator(
            [OrchestrationTrigger] IDurableOrchestrationContext context)
        {
            var outputs = new List<string>();
            ADFRequest data = context.GetInput<ADFRequest>();
            outputs.Add(await context.CallActivityAsync<string>("GetADF_AdHoc_Process", data));   
            return outputs;
        }

        // Security getkey 
        private static byte[] GetKey(string password)
        {
            string pwd = null;

            if (Encoding.UTF8.GetByteCount(password) < 24)
            {
                pwd = password.PadRight(24, ' ');
            }
            else
            {
                pwd = password.Substring(0, 24);
            }
            return Encoding.UTF8.GetBytes(pwd);
        }

        /// <summary>
        /// Decrypt using 3DES (192 bits)
        /// </summary>
        private static string Decrypt(string data)
        {
            TripleDESCryptoServiceProvider DES = new TripleDESCryptoServiceProvider();
            DES.Mode = CipherMode.ECB;
            DES.Key = GetKey("ttttt");
            DES.Padding = PaddingMode.PKCS7;
            ICryptoTransform DESEncrypt = DES.CreateDecryptor();
            Byte[] Buffer = Convert.FromBase64String(data.Replace(" ", "+"));
            return Encoding.UTF8.GetString(DESEncrypt.TransformFinalBlock(Buffer, 0, Buffer.Length));
        }

        static public int GetADToken(ILogger il)
        {
            string keyVaultName = Environment.GetEnvironmentVariable("keyvault"); //future use of keyvault?
           // var kvclient = new SecretClient(new Uri(kvUri), new DefaultAzureCredential());
           // var clientidpbiref = kvclient.GetSecretAsync("clientidpbiref").Result;
            //var clientid = clientidpbiref.Value.Value;
            //var tenantID = kvclient.GetSecretAsync("tenantidpbiref").Result.Value.Value;
            //var csecret = kvclient.GetSecretAsync("cspbirefresh").Result.Value.Value;
                     
            //  Authenticate and create a data factory management client
            var context = new AuthenticationContext("https://login.microsoftonline.com/" + tenant_id);
            ClientCredential cc = new ClientCredential(client_id, client_key);
            AuthenticationResult result = context.AcquireTokenAsync(
                "https://management.azure.com/", cc).Result;
            sauth = "Bearer " + result.AccessToken;
             return 0;
        } 

        static public string SQLParseInsert(string jsonIn, bool TruncateTable,ILogger il)
        {
            errmsg = "";
            try
            {
                SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();
                builder.DataSource = sqlServer;
                builder.UserID = sqlUserID;
                builder.Password = sqlPassword;
                builder.InitialCatalog = sqlInitialCatalog;
                using (SqlConnection connection = new SqlConnection(builder.ConnectionString))
                {
                    // Replace single quotes in json response
                    jsonIn = jsonIn.Replace("'", "");
                    if (jsonIn.Contains("\"value\": []") == true)
                    {
                        jsonIn = "0";
                    }
                    String sql = "";
                    sql = "dbo.usp_InsertADFProcess"; // proc inserts JSON response to a table

                    using (SqlCommand command = new SqlCommand(sql, connection))
                    {
                        connection.Open();
                        command.CommandTimeout = 60;
                        command.CommandType = CommandType.StoredProcedure;
                        command.Parameters.Add(new SqlParameter("@TruncateTable", TruncateTable));
                        command.Parameters.Add(new SqlParameter("@JsonResponse", jsonIn));
                        command.Parameters.Add(new SqlParameter("@LoadDate", loaddate));
                        rcInsert = command.ExecuteNonQuery();
                         il.LogInformation("Insert rc:" + rcInsert);

                    }
                }
                return errmsg;
            }
            catch (SqlException e)
            {
                Console.WriteLine(e.ToString());
                errmsg = "Error:" + e.ToString();
                return errmsg;
            }
        }

        static public int ADF_GETfails(string atoken, ILogger il) //trigger runs do not capture errors if more than 1 pipeline is attached
        {   // Need to capture pipeline errors since trigger doesn't show errored - MS bug.
            loaddate = string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", TimeZoneInfo.ConvertTimeFromUtc(DateTime.UtcNow, easternZone));
            loaddateUTC =  DateTime.UtcNow;
            lastUpdatedBefore = string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", loaddateUTC);

            loaddateUTC = loaddateUTC.AddHours(-LastNhours);
            lastUpdatedAfter = string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", loaddateUTC);

            //Get trigger runs=POST /queryTriggerRuns?api-version=2018-06-01
            //GET https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}?api-version=2018-06-01
            //POST https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}/triggerRuns/{runId}/rerun?api-version=2018-06-01

            //pipeline history=POST https.....{factoryName}/queryPipelineRuns?api-version=2018-06-01
            string DatasetRefURL = "";
            string AdfPostbody = ""; 

            AdfPostbody = @" {
          ""lastUpdatedAfter"": """+ lastUpdatedAfter + @""",
          ""lastUpdatedBefore"": """ + lastUpdatedBefore + @""",
          ""filters"": 
         [
            {
            ""operand"": ""Status"",
            ""operator"": ""NotIn"",
            ""values"": [""xSucceeded"",""InProgress""]
            }
         ]
            , ""continuationToken"": """"
        }";
            //for getting History of runs
            DatasetRefURL = String.Concat(ADFgatewayURL, "/" + "queryPipelineRuns?api-version=2018-06-01");

            var dsrefclient = new RestClient(DatasetRefURL);
            dsrefclient.Timeout = -1;
            var adfrequest = new RestRequest(Method.POST); //post

            adfrequest.AddJsonBody(AdfPostbody);
            PagingToken = "";

            adfrequest.AddHeader("Authorization", atoken);
            IRestResponse adfresponse = dsrefclient.Execute(adfrequest);
            string adfRef = adfresponse.Content;
            var successful = adfresponse.IsSuccessful;
            if (successful)
            {
                JObject jobj = JObject.Parse(adfRef);
                // get PagingToken if not NULL
                try
                {
                    PagingToken = jobj["continuationToken"].ToString();

                }
                catch (Exception) // no next page found
                {

                    PagingToken ="";
                }

                if (adfRef.Contains("\"value\"") == true)
                {
                    if (SQLParseInsert(adfRef, false, il).Length > 0)
                    { //error caught
                        throw new FunctionFailedException(errmsg);
                    }
                }
                else //Unknown refresh status
                {
                    Console.WriteLine("Insert unknown: No data--->>> " + adfRef);
                    SQLParseInsert("", false, il);
                }

                while (PagingToken.Length>1) //page2++
                {

                    // call next page...  var scrollResp = clientlow.Scroll<StringResponse>(scrbody);
                    AdfPostbody = @" {
                      ""lastUpdatedAfter"": """ + lastUpdatedAfter + @""",
                      ""lastUpdatedBefore"": """ + lastUpdatedBefore + @""",
                      ""filters"": 
                     [
                        {
                        ""operand"": ""Status"",
                        ""operator"": ""NotIn"",
                        ""values"": [""xSucceeded"",""InProgress""]
                        }
                     ]
                        , ""continuationToken"": """ + PagingToken + @"""
                    }";

                    adfrequest = new RestRequest(Method.POST); 
                    adfrequest.AddJsonBody(AdfPostbody);
                    adfrequest.AddHeader("Authorization", atoken);
                    IRestResponse pagingResponse = dsrefclient.Execute(adfrequest);
                    string pagingResponseStr = pagingResponse.Content;
                     jobj = JObject.Parse(pagingResponseStr);
                    // get next PagingToken with NULL handler
                    try
                    {
                        PagingToken = jobj["continuationToken"].ToString();

                    }
                    catch (Exception) // no next page found
                    {

                        PagingToken = "";
                    }

                    if (adfRef.Contains("\"value\"") == true)
                    {
                        if (SQLParseInsert(pagingResponseStr, false, il).Length > 0)
                        { //error caught
                            throw new FunctionFailedException(errmsg);
                        }
                    }

              
                    if (PagingToken.Length == 0)
                    {
                        Console.WriteLine(PagingToken);
                        Console.WriteLine("Blank PagingToken" + DateTime.Now);
                        break;
                    }
                }

                return 0;
            }
            else
            {
                return 1;
            }

         
          

        }

        static public void RerunLoop(ILogger il)
        {
            ADF_RerunTrigger(sauth, il, "trg_rotatex", "08585391313281552083696352398CU57"); //test 
            //read list and run ADF_RerunTrigger
         /*   foreach (var trgkey in dictTriggers.Keys)
            {
                Console.WriteLine(trgkey +"" + dictTriggers[trgkey]);
                ADF_RerunTrigger(sauth, il, trgkey, dictTriggers[trgkey]);

            }
         */

        }
        static public void ADF_RerunTrigger(string atoken, ILogger il,string trgName,string trgRunID) 
        {
            loaddate = string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", TimeZoneInfo.ConvertTimeFromUtc(DateTime.UtcNow, easternZone));
            string DatasetRefURL = "";
            string AdfPostbody = ""; //only used for queryTriggerRuns
          /* 
            AdfPostbody = @" {
          ""lastUpdatedAfter"": ""2022-08-16T00:36:44.3345758Z"",
          ""lastUpdatedBefore"": ""2022-09-16T00:49:48.3686473Z"",
          ""filters"": [
            {
              ""operand"": ""TriggerName"",
              ""operator"": ""Equals"",
              ""values"": [
                ""trg_rotatex""
              ]
            },
            {
            ""operand"": ""Status"",
            ""operator"": ""NotEquals"",
            ""values"": [
            ""Succeeded""
            ]
            }
          ]
        }";
          */

            // triggers/{triggerName}/triggerRuns/{runId}/rerun?api-version=2018-06-01

            DatasetRefURL = String.Concat(ADFgatewayURL, "/" + "triggers/", trgName, "/triggerRuns/", trgRunID, "/rerun?api-version=2018-06-01");
          
            var dsrefclient = new RestClient(DatasetRefURL);
            dsrefclient.Timeout = -1;
          var adfRerun = new RestRequest(Method.POST); //post
            adfRerun.AddHeader("Authorization", atoken);
            IRestResponse adfresponse = dsrefclient.Execute(adfRerun);
            string adfRerunRespoonse = adfresponse.Content;
        }

        static public string SQLGetReruns(string optparam, ILogger il)
        {
            errmsg = "";
            try
            {
                SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder();
                builder.DataSource = sqlServer;
                builder.UserID = sqlUserID;
                builder.Password = sqlPassword;
                builder.InitialCatalog = sqlInitialCatalog;

                using (SqlConnection connection = new SqlConnection(builder.ConnectionString))
                {
                    String sql = "";
                    sql = "select * from dbo.vwADFrerunTrigger ";
 
                    using (SqlCommand command = new SqlCommand(sql, connection))
                    {
                        connection.Open();
                        command.CommandTimeout = 60;
                        command.CommandType = CommandType.Text;
                        using (SqlDataReader reader = command.ExecuteReader())
                        {

                            while (reader.Read()) //list has t be unique for dictionary
                            {
                                dictTriggers.Add(reader.GetString(0), reader.GetString(1));
                            }
                        }

                        il.LogInformation("rows" +  "=" + rcInsert);

                    }
                }
                return errmsg;
            }
            catch (SqlException e)
            {
                Console.WriteLine(e.ToString());
                errmsg = "Error:" + e.ToString();
                return errmsg;
            }
        }



        [FunctionName("GetADF_AdHoc_Process")]
         public static string GetADF_AdHocProcess([ActivityTrigger] ADFRequest ADFReq, ILogger log)
        {
            log.LogInformation($"AD token begins...");
            GetADToken(log);
            log.LogInformation($"AD token obtained: {DateTime.Now}");
            sqlPassword = Decrypt("ujvt89xxxxxxxx");
            sqlPassword.ToString();       
            foreach (var adfset in ADFReq.ADFsettings)
            {
                log.LogInformation("ActivityFunction reading:" + adfset.SettingName);
                if (adfset.SettingName == "PBIWSfilter")
                {
                    PBIWSfilter = adfset.SettingVal.Trim();
                }
            }
            /**************************************** run process ***************************************************************************/
          //   ADF_GETfails(sauth, log);
             SQLGetReruns(sauth, log);
            RerunLoop(log);

            log.LogInformation("ADF proc end:" + string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", DateTime.Now));
            return "ADF run OK";
        }

        public class ADFSET
        {
            public string SettingName { get; set; }
            public string SettingVal { get; set; }
        }

        public class ADFRequest
        {
            public List<ADFSET> ADFsettings { get; set; }
        }

        class ADFparams
        {
            public List<string> ParamNames { get; set; }
        }

        [FunctionName("GetADF_AdHoc_HttpStart")]
            public static async Task<HttpResponseMessage> HttpStart(
            [HttpTrigger(AuthorizationLevel.Anonymous, "post")] HttpRequestMessage req,
            [DurableClient] IDurableOrchestrationClient starter,
            ILogger log)
        {
            log.LogInformation("ADF fn start:" + string.Format("{0:yyyy-MM-ddTHH:mm:ss.fff}", DateTime.Now));
            req.Content.Headers.Remove("Content-Type");
            req.Content.Headers.Add("Content-Type", "application/json");

            var data = await req.Content.ReadAsAsync<ADFRequest>();
            // Function input comes from the request content.
            string instanceId = await starter.StartNewAsync("GetADF_AdHoc", data);
            log.LogInformation($"Started orchestration with ID = '{instanceId}'.");

            return starter.CreateCheckStatusResponse(req, instanceId);
        }
    }
}